<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Log;

class CheckPermission
{
    public function handle(Request $request, Closure $next, $permission): Response
    {
        $user = $request->user();

        if (!$user) {
            Log::warning('No authenticated user found in request.');
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthenticated.',
            ], 401);
        }

        // Eager load roles and permissions
        $user->load('roles');

        $rolesPermissions = $user->roles->pluck('Permissions')->flatten()->pluck('name')->unique();
        Log::info('User Roles: ' . json_encode($user->roles->pluck('Name')));
        Log::info('User Permissions: ' . json_encode($rolesPermissions));

        if (!$user->hasPermission($permission)) {
            Log::warning("User lacks permission: $permission");
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized action.',
            ], 403);
        }

        return $next($request);
    }
}
